#!/bin/bash
# txtsvg: convert path of PostScript text to SVG path data
# by Gordon Kindlmann for his "Laser Cutting By Program" class
# Copyright (C) 2019  Universty of Chicago

# txtsvg.sh is the driver script. Please re-write me in a real language.

set -o errexit
set -o nounset
shopt -s expand_aliases
JUNK=""
function junk { JUNK="$JUNK $@"; }
function cleanup { rm -rf $JUNK; }
trap cleanup err exit int term

if [[ ! ( $# -eq 3 || $# -eq 4 ) ]]; then
    echo >&2 "usage: "
    echo >&2 ""
    echo >&2 "    $0 txt font out.svg [out.ps]"
    echo >&2 ""
    echo >&2 "where txt is letter(s) to draw, font is font name "
    echo >&2 "(run \"gs -dBATCH -q fontlist.ps | sort\" to see list)"
    echo >&2 "out.svg is svg output file, and out.ps is optional"
    echo >&2 "PostScript output file (else tmp file is removed)."
    echo >&2 "You can extract just the <path> by:"
    echo >&2 "   grep '<path' out.svg"
    exit 1
fi
if [ ! -f txtsvg.pre-ps ]; then
    echo >&2 "$0: ERROR: missing needed file txtsvg.pre-ps"
    exit 1
fi
command -v gs >/dev/null 2>&1 || { echo >&2 \
"$0: ERROR: need GhostScript interpreter \"gs\" to run"
exit 1; }

# special characters
# '\\('  for (
# '\\)'  for )
# '\\\\' for \
# '$'    for $
# but can't seem to handle forward slash,
# because of use of how sed is invoked
TXT=$1
FONT=$2
OUT=$3
if [[ $# -eq 4 ]]; then
    TMPPS=$4
else
    TMPPS=__tmp.ps
    junk $TMPPS
fi

cat txtsvg.pre-ps |
    sed -e s/THETXT/$TXT/ |
    sed -e s/THEFONT/$FONT/ > $TMPPS

gs -dBATCH -q $TMPPS > __tmp.pdata
junk __tmp.pdata

rm -f $OUT
touch $OUT
# This is to permit viewing the svg path in the context of a
# self-contained SVG file, but it not important for the purpose of
# txtsvg
cat >> $OUT <<EOF
<svg xmlns="http://www.w3.org/2000/svg" version="1.1"
  width="612pt"
  height="792pt"
  viewBox="0 0 612 792">
<defs>
   <style type="text/css"><![CDATA[
     path {
        stroke-width: 0.1;
        fill: #eeeeee;
        stroke: #ff0000
       }
     ]]></style>
  </defs>
<g transform="matrix(2 0 0 2 100 200)">
EOF

# this puts all the path data on one line;
# cat __tmp.pdata >> $OUT would keep the multiple lines
echo `cat __tmp.pdata` >> $OUT

cat >> $OUT <<EOF
</g>
</svg>
EOF
